import csv
import pdb
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
import seaborn as sns

tips = sns.load_dataset("tips")


xhmmcalls = np.load('../outputs/data_list_xhmm_preds_test_weightedcrossent_embeddingout.npy')[1500:]
cnvnatorcalls = np.load('../outputs/data_list_cnvnator_preds_test_weightedcrossent_embeddingout.npy')[1500:]
chrs = np.load('../outputs/data_list_chrs_test_weightedcrossent_embeddingout.npy')[1500:]
inds = np.load('../outputs/data_list_indexes_test_weightedcrossent_embeddingout.npy')[1500:]
polished = np.load('../outputs/polished_rev12.npy')[1500:]
gcs = np.load('../outputs/data_list_gcs.npy')
mapp = np.load('../outputs/data_list_mapp.npy')

corrected = []
correctedgcs = []
agreedgcs = []
for i in range(len(xhmmcalls)):
	if np.argmax(xhmmcalls[i]) == np.argmax(cnvnatorcalls[i]):
		corrected.append('DECoNT Agrees') # agrees
		agreedgcs.append(gcs[i])
	elif np.argmax(polished[i]) == np.argmax(cnvnatorcalls[i]):
		corrected.append('DECoNT Corrects') # correct
		correctedgcs.append(gcs[i])
	else: 
		corrected.append('DECoNT Agrees') # agrees
		agreedgcs.append(gcs[i])


corrected = np.asarray(corrected)


fig, ax = plt.subplots()
g = sns.stripplot(x=corrected, y=gcs)
g.set(ylim=(20, None))
plt.ylabel("GC Content", fontweight='normal', fontsize=14)

plt.plot()


#ax.plot([0,1],[0,1], transform=ax.transAxes, color='black', linestyle='--', linewidth=0.4)

plt.show()



pdb.set_trace()
